CREATE TABLE IF NOT EXISTS bots (
    id BIGINT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
    bot_id VARCHAR(128) NOT NULL UNIQUE,
    status VARCHAR(32) NOT NULL DEFAULT 'unknown',
    last_seen_at DATETIME NOT NULL,
    last_sequence BIGINT UNSIGNED NOT NULL DEFAULT 0,
    created_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
    updated_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
);

CREATE TABLE IF NOT EXISTS api_nonces (
    id BIGINT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
    api_key VARCHAR(128) NOT NULL,
    nonce VARCHAR(64) NOT NULL,
    created_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
    UNIQUE KEY uq_api_nonce (api_key, nonce),
    KEY idx_created_at (created_at)
);

CREATE TABLE IF NOT EXISTS bot_events (
    id BIGINT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
    bot_id VARCHAR(128) NOT NULL,
    sequence BIGINT UNSIGNED NOT NULL,
    event_type VARCHAR(64) NOT NULL,
    severity VARCHAR(16) NOT NULL DEFAULT 'info',
    symbol VARCHAR(128) NULL,
    message TEXT NOT NULL,
    trade_json JSON NULL,
    metrics_json JSON NULL,
    context_json JSON NULL,
    payload_json JSON NOT NULL,
    sent_at_utc DATETIME NOT NULL,
    created_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
    KEY idx_bot_created (bot_id, created_at),
    KEY idx_event_type (event_type),
    KEY idx_symbol (symbol)
);

CREATE TABLE IF NOT EXISTS bot_state_snapshots (
    id BIGINT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
    bot_id VARCHAR(128) NOT NULL,
    symbol VARCHAR(128) NOT NULL,
    sequence BIGINT UNSIGNED NOT NULL,
    stake_index INT NOT NULL DEFAULT 0,
    stake DECIMAL(16, 4) NOT NULL DEFAULT 0,
    hedge_loss_threshold DECIMAL(16, 4) NOT NULL DEFAULT 0,
    trailing_stop_threshold DECIMAL(16, 4) NOT NULL DEFAULT 0,
    last_trade_time_utc DATETIME NULL,
    restart_time_utc DATETIME NULL,
    max_buy_profit DECIMAL(16, 4) NOT NULL DEFAULT 0,
    max_sell_profit DECIMAL(16, 4) NOT NULL DEFAULT 0,
    is_buy_trend TINYINT(1) NOT NULL DEFAULT 0,
    is_sell_trend TINYINT(1) NOT NULL DEFAULT 0,
    open_positions_count INT NOT NULL DEFAULT 0,
    open_positions_json JSON NULL,
    indicators_json JSON NULL,
    payload_json JSON NOT NULL,
    sent_at_utc DATETIME NOT NULL,
    created_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
    KEY idx_bot_symbol_created (bot_id, symbol, created_at),
    KEY idx_sent_at (sent_at_utc)
);

CREATE TABLE IF NOT EXISTS trades (
    id BIGINT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
    bot_id VARCHAR(128) NOT NULL,
    symbol VARCHAR(128) NULL,
    position_id VARCHAR(64) NOT NULL,
    label VARCHAR(128) NULL,
    side VARCHAR(8) NULL,
    volume DECIMAL(16, 4) NULL,
    entry_price DECIMAL(18, 8) NULL,
    exit_price DECIMAL(18, 8) NULL,
    gross_profit DECIMAL(16, 4) NULL,
    opened_at DATETIME NULL,
    closed_at DATETIME NULL,
    open_event_id BIGINT UNSIGNED NULL,
    close_event_id BIGINT UNSIGNED NULL,
    created_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
    updated_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    UNIQUE KEY uq_bot_position (bot_id, position_id),
    KEY idx_bot_closed (bot_id, closed_at)
);
