# cTrader Bot Monitoring Dashboard (PHP)

This module provides:

- signed telemetry ingestion API
- MySQL persistence for events, snapshots, trades
- live dashboard UI with bot status, events, snapshots, and trade history

## 1) Server layout

Place this folder on your VPS (example path):

- `/var/www/html/dashboard`

Expected files:

- `index.php` (dashboard UI)
- `api/index.php` (API endpoints)
- `migrations/001_init.sql` (DB schema)
- `ops/simulate_telemetry.php` (test sender)

## 2) Configuration setup (`config.php`)

Copy and edit:

```bash
cp config.example.php config.php
```

Then update in `config.php`:

- DB credentials (`db.host`, `db.database`, `db.username`, `db.password`)
- `security.webhook_secret`

## 3) Create database tables

```bash
mysql -u <user> -p <database_name> < migrations/001_init.sql
```

## 4) Apache config

Enable rewrite module:

```bash
sudo a2enmod rewrite
sudo systemctl restart apache2
```

Make sure your VirtualHost allows `.htaccess` rewrites for this directory (`AllowOverride All`).

## 5) API endpoints

Base:

- `POST /dashboard/api/telemetry/event`
- `POST /dashboard/api/telemetry/snapshot`
- `POST /dashboard/api/telemetry/heartbeat`
- `GET /dashboard/api/dashboard/overview`
- `GET /dashboard/api/dashboard/events`
- `GET /dashboard/api/dashboard/snapshots`
- `GET /dashboard/api/dashboard/trades`

## 6) cBot parameters

In `cbot/MultiSymbolScalpingBot.cs`, set:

- `Telemetry Enabled = true`
- `Telemetry Base URL = https://<your-domain>/dashboard/api/telemetry`
- `Webhook Secret = <WEBHOOK_SECRET>`
- `Bot ID = deriv-ctrader-bot-01`

## 7) Verify end-to-end before live cBot

Run simulator:

```bash
php ops/simulate_telemetry.php "https://<your-domain>/dashboard/api/telemetry" "<api_key>" "<api_secret>" "deriv-ctrader-bot-01"
```

Then open dashboard:

- `https://<your-domain>/dashboard/`

You should see:

- bot online status
- test events
- snapshots
- trades (if trade events include open/close)

## 8) Retention cleanup (cron)

Schedule periodic cleanup:

```bash
php /var/www/html/dashboard/ops/cleanup.php
```

Example cron (daily):

```bash
0 2 * * * /usr/bin/php /var/www/html/dashboard/ops/cleanup.php >> /var/log/dashboard-cleanup.log 2>&1
```
